using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a coil corpse" )]
	public class Coil : BogThing
	{
		[Constructable]
		public Coil () : base()
		{
			ActiveSpeed = 0.1;
			PassiveSpeed = 0.2;
		
			Name = "a coil";
			Body = 0x5B;
			Hue = 0x3F;
			BaseSoundID = 0xDB;

			SetStr( 205, 343 );
			SetDex( 202, 283 );
			SetInt( 88, 142 );

			SetHits( 628, 1291 );

			SetDamage( 8, 21 );

			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Poison, 50 );

			SetResistance( ResistanceType.Physical, 56, 62 );
			SetResistance( ResistanceType.Fire, 25, 29 );
			SetResistance( ResistanceType.Cold, 25, 30 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 27, 30 );

			SetSkill( SkillName.Poisoning, 107.8, 117.8 );
			SetSkill( SkillName.Anatomy, 121.2,  131.2 );
			SetSkill( SkillName.MagicResist, 103.7, 113.7 );
			SetSkill( SkillName.Tactics, 127.6, 137.6 );
			SetSkill( SkillName.Wrestling, 121.8, 131.8 );

			Fame = 12000;
			Karma = -12000;

			VirtualArmor = 40;
			
			PackGem( 2 );
			PackItem( new Bone() );	
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosUltraRich );
		}		
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.MortalStrike;
		}
		
// 		public override void OnDeath( Container c )
// 		{
// 			base.OnDeath( c );		
// 			
// 			c.DropItem( new CoilsFang() );
// 			
// // 			if ( Utility.RandomDouble() < 0.025 )
// // 			{
// // 				switch( Utility.Random( 5 ) )
// // 				{
// // 					case 0: c.DropItem( new AssassinChest() ); break;
// // 					case 1: c.DropItem( new DeathGloves() ); break;
// // 					case 2: c.DropItem( new LeafweaveLegs() ); break;
// // 					case 3: c.DropItem( new HunterLegs() ); break;
// // 					case 4: c.DropItem( new MyrmidonLegs() ); break;
// // 				}
// // 			}
// 		}

		public override Poison HitPoison{ get{ return Poison.Lethal; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override int Hides{ get{ return 48; } }
		public override int Meat{ get{ return 1; } }

		public Coil( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
